from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import DSLHaz

class BoxArena(Arenas.SuperArena):
    "Nice tabletop arena, with a 'Twist'."
    name = "DSL Blade Arena"
    preview = "DSLSpinnerArena/DSLspinner_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-12, 16, 12, -16)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLSpinnerArena/DSLspinner.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(.46, .637, .888)
        
        degrad = 0.01745
        self.AddStaticCamera("                StaticCam-Over", (0, 13.5, 0), (90*degrad,0*degrad), 130*degrad)
        self.AddStaticCamera("                StaticCam-1", (20, 12, -26), (34*degrad,320*degrad),68*degrad)
        self.AddStaticCamera("                StaticCam-2", (-20, 12, 26), (34*degrad,140*degrad), 68*degrad)
        self.AddStaticCamera("                StaticCam-3", (0, 14, 12), (68*degrad,180*degrad), 100*degrad)
        self.AddStaticCamera("                StaticCam-4", (0, 14, -12), (68*degrad,0*degrad), 100*degrad)

        self.AddWatchCamera("                WatchCam-1", (18, 13, -20), (16, 48, 35*degrad, 20*degrad))
        self.AddWatchCamera("                WatchCam-2", (-18, 13, 20), (16, 48, 35*degrad, 20*degrad))
        self.AddWatchCamera("                WatchCam-3", (0, 10, 24), (6, 22, 35*degrad, 35*degrad))
        self.AddWatchCamera("                WatchCam-4", (0, 10, -24), (6, 22, 35*degrad, 35*degrad))
        self.AddWatchCamera("                SpinnerCam", (0, 2, 0), (5, 25, 65*degrad, 45*degrad))

        #self.AddWatchCamera("Watch Cam 1", (-8, 12, 10), (16, 32, 55*degrad, 30*degrad))
        #self.AddWatchCamera("Watch Cam 4", (10, 10, 0), (12, 28, 65*degrad, 20*degrad))

        
        self.players = ()

        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        # Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-8.17686,0.676244,12.4283), (-12.4182,0.676244,12.4283))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-12.4182,0.676244,12.4283), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.25999,0.676244,12.4283), (-2.49123,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (2.25999,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((12.413,0.676244,12.4283), (7.93297,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,1.91641), (12.413,0.676244,12.4283))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (12.413,0.676244,-12.4279), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (12.413,0.676244,-12.4279), (12.413,0.676244,-1.93329))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (8.17711,0.676244,-12.4279), (12.413,0.676244,-12.4279))
        self.AddShadowTriangle((-2.26871,0.676244,-12.4279), (2.49519,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (-2.26871,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-1.8361), (-12.4182,0.676244,-12.4279))
        self.AddShadowTriangle((-2.49123,0.676244,9.91855), (-8.17686,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.49519,0.676244,-9.92447), (8.17711,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (-10.2877,0.676244,-1.8361), (-2.26871,0.676244,-9.92447))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (7.93297,0.676244,9.91855), (2.25999,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (-2.49123,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (2.25999,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (10.2878,0.676244,1.91641), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (10.2878,0.676244,-1.93329), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (2.49519,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-7.93688,0.676244,-9.92447), (-2.26871,0.676244,-9.92447))
        
        # Hazard Shadow Triangles
        self.AddShadowTriangle((-8.0217,0.407085,-12.2193), (-2.21868,0.407085,-12.2193), (-2.21868,0.407085,-9.90302))
        self.AddShadowTriangle((-2.21868,0.407085,-9.90302), (-8.0217,0.407085,-9.90302), (-8.0217,0.407085,-12.2193))
        self.AddShadowTriangle((2.42165,0.407085,-12.2193), (8.22466,0.407085,-12.2193), (8.22466,0.407085,-9.90302))
        self.AddShadowTriangle((8.22466,0.407085,-9.90302), (2.42165,0.407085,-9.90302), (2.42165,0.407085,-12.2193))
        self.AddShadowTriangle((-8.24321,0.407085,9.84521), (-2.4402,0.407085,9.84521), (-2.4402,0.407085,12.1615))
        self.AddShadowTriangle((-2.4402,0.407085,12.1615), (-8.24321,0.407085,12.1615), (-8.24321,0.407085,9.84521))
        self.AddShadowTriangle((2.20013,0.407085,9.84521), (8.00315,0.407085,9.84521), (8.00315,0.407085,12.1615))
        self.AddShadowTriangle((8.00315,0.407085,12.1615), (2.20013,0.407085,12.1615), (2.20013,0.407085,9.84521))
        
    def HazardsOn(self, on):
        self.spinner = self.GetHinge("Hinge01")
        self.spinner.SetAutoLocks(False, False)
        self.spinner.Lock(False)
        self.SetSubMaterialSound("blade_display", "metal", 1.0, "Sounds\\spinnerhit.wav")
        if on:
            self.ambience = plus.createSound("Sounds/spinnerspin.wav", False, (0, 0, 0))
            plus.loopSound(self.ambience)
            self.spinner.SetPowerSettings(35,150000)
            self.spinner.SetDirection(100)
            self.spinner.ApplyTorque(10)
        #box off spiner
        self.AddCollisionLine((-3.5, 3.5), (3.5, 3.5))
        self.AddCollisionLine((3.5, 3.5), (3.5, -3.5))
        self.AddCollisionLine((3.5, -3.5), (-3.5, -3.5))
        self.AddCollisionLine((-3.5, -3.5), (-3.5, 3.5))
        self.AddCollisionLine((-4.0, 4.0), (4.0, 4.0))
        self.AddCollisionLine((4.0, 4.0), (4.0, -4.0))
        self.AddCollisionLine((4.0, -4.0), (-4.0, -4.0))
        self.AddCollisionLine((-4.0, -4.0), (-4.0, 4.0))
        #outer walls
        self.AddCollisionLine((-15.5, 12.5), (-11, 18))
        self.AddCollisionLine((-11, 18), (11, 18))
        self.AddCollisionLine((11, 18), (15.5, 12.5))
        self.AddCollisionLine((15.5, 12.5), (15.5, -12.5))
        self.AddCollisionLine((15.5, -12.5), (11, -18))
        self.AddCollisionLine((11, -18), (-11, -18))
        self.AddCollisionLine((-11, -18), (-15.5, -12.5))
        self.AddCollisionLine((-15.5, -12.5), (-15.5, 12.5))
        #spinner ai guide
        self.AddPOV(0, (10, 0), (0, 2))
        self.AddPOV(1, (0, 10), (1, 3))
        self.AddPOV(2, (-10, 0), (2, 0))
        self.AddPOV(3, (0, -10), (3, 1))

        return Arenas.SuperArena.HazardsOn(self, on)

    def __del__(self):
        if self.bHazardsOn:
            plus.removeSound(self.ambience)
        elif self.endmusic:
            plus.stopSound(self.endmusic)
            plus.removeSound(self.endmusic)
        Arenas.SuperArena.__del__(self)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()

        Arenas.SuperArena.Activate(self, on)

    def Tick(self):
        #check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -5:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)

 
       
Arenas.register(BoxArena)
